/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.selector;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import noppes.npcs.constants.EnumCompanionJobs;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobGuard;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.companion.CompanionGuard;
import noppes.npcs.util.Util;

public class NPCAttackSelector
implements Predicate<EntityLivingBase> {
    private final EntityNPCInterface npc;

    public NPCAttackSelector(EntityNPCInterface npcIn) {
        this.npc = npcIn;
    }

    public boolean apply(EntityLivingBase entity) {
        if (entity == null || !entity.func_70089_S() || entity == this.npc || !this.npc.isInRange((Entity)entity, this.npc.stats.aggroRange) || entity.func_110143_aJ() <= 0.1f || !Util.instance.npcCanSeeTarget((EntityLivingBase)this.npc, entity, false, true)) {
            return false;
        }
        if (!this.npc.isFollower() && this.npc.ais.shouldReturnHome()) {
            int allowedDistance = this.npc.stats.aggroRange * 2;
            if (this.npc.ais.getMovingType() == 1) {
                allowedDistance += this.npc.ais.walkingRange;
            }
            double distance = entity.func_70092_e((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos());
            if (this.npc.ais.getMovingType() == 2) {
                int[] arr = this.npc.ais.getCurrentMovingPath();
                distance = entity.func_70092_e((double)arr[0], (double)arr[1], (double)arr[2]);
            }
            if (distance > (double)(allowedDistance * allowedDistance)) {
                return false;
            }
        }
        if (this.npc.advanced.jobInterface instanceof JobGuard && ((JobGuard)this.npc.advanced.jobInterface).isEntityApplicable((Entity)entity)) {
            return true;
        }
        if (this.npc.advanced.roleInterface instanceof RoleCompanion) {
            RoleCompanion role = (RoleCompanion)this.npc.advanced.roleInterface;
            if (role.job == EnumCompanionJobs.GUARD && ((CompanionGuard)role.jobInterface).isEntityApplicable((Entity)entity)) {
                return true;
            }
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            return this.npc.advanced.isAggressiveToPlayer((EntityPlayer)entity) && !player.field_71075_bZ.field_75102_a;
        }
        if (entity instanceof EntityNPCInterface) {
            if (((EntityNPCInterface)entity).isKilled()) {
                return false;
            }
            return this.npc.advanced.isAggressiveToNpc((EntityNPCInterface)entity);
        }
        return false;
    }
}

